
#ifndef _XF_DOCUMENT_H
#define _XF_DOCUMENT_H

#include "BaseDocument.h"



#define STR_EDIT_TEMPLATE_FILE							okutil_get_origin_path(ORIGIN_PATH_SYSTEM)+"XF2WordTemplate.dot"
#define STR_CHM_TEMPLATE_FILE							okutil_get_origin_path(ORIGIN_PATH_SYSTEM)+"XF2WordTemplateCHM.dot"
#define STR_COMBOLIST_TEMPLATE_FILE						okutil_get_origin_path(ORIGIN_PATH_SYSTEM)+"XF2WordVarOptionTemplate.dot"

class XFWord : public WordDocument
{
public:
	XFWord(bool bVisible);
	~XFWord();
	
	//virtual
	bool OpenDoc(LPCSTR lpcszFile=NULL);	//NULL to open an empty one
	bool SaveDoc(LPCSTR lpcszFileName);
	bool DeleteSection(LPCSTR lpcszBookMark);
	bool AddString(const string& str, LPCSTR lpcszTable=NULL, LPCSTR lpcszBookMark=NULL, LPCSTR lpcszStyle=NULL);
	///Joseph 11/30/06	SPLITE_TABLE_CELL_FOR_TREENODE_VARIABLE
	//bool AddRichText(const vector<char>& vcDoc, LPCSTR lpcszTable, LPCSTR lpcszBookMark=NULL, LPCSTR lpcszStyle=NULL);
	bool AddRichText(const vector<char>& vcDoc, LPCSTR lpcszTable, LPCSTR lpcszBookMark=NULL, LPCSTR lpcszStyle=NULL, bool bIsTable = true);
	///End SPLITE_TABLE_CELL_FOR_TREENODE_VARIABLE
	//bool AddTables(const vector<string>& vsVals, int nCols, LPCSTR lpcszNewTableName, LPCSTR lpcszBookMark=NULL, LPCSTR lpcszCellBookMark=NULL, int nNumTitleLine=0, LPCSTR lpcszNewTableStyle=NULL);
	//bool SetTable(const vector<string>& vsVals, int nCols, int& nGoToTableIndex, LPCSTR lpcszGoToBookMark=NULL, LPCSTR lpcszContentTemplate=NULL, int nNumHeaderLine=0, LPCSTR lpcszNewTableName=NULL, LPCSTR lpcszTableCellBookMark=NULL);
	
	bool AddImage(const vector<char>& vcDoc, LPCSTR lpcszTable, LPCSTR lpcszBookMark =NULL);/// ----AW 11/03/05 ADD_HELP_SCREEN_SHOT

	bool SplitTableCell(int nTableIndex=0, int nRow=0, int nCol=-1, int nCols=-1, LPCSTR lpcszTableBookMark=NULL, const vector<string>& vsVals=NULL, int nValCols=0, LPCSTR lpcszNewTableName=NULL, LPCSTR lpcszCellBookMark=NULL);
	bool SplitCellTwoRows(LPCSTR lpcszCellBookMark = NULL, LPCSTR lpcszNewCellName = NULL);	///Joseph 11/30/06	SPLITE_TABLE_CELL_FOR_TREENODE_VARIABLE
	bool GetString(LPCSTR lpcszBookMark, string& str, bool bTableString=true);
};

XFWord::XFWord(bool bVisible) : WordDocument(bVisible)
{
}
XFWord::~XFWord()
{
	//~WordDocument();
}
bool XFWord::OpenDoc(LPCSTR lpcszFile)	//NULL to open an empty one
{
	string strFile(lpcszFile);
	try
	{
		if(strFile.IsEmpty())
			m_oActiveDoc = m_oWord.Documents.Add();	// Add a blank document
		else
			m_oActiveDoc = m_oWord.Documents.Open(FileName := strFile, ReadOnly := true);	//set as read only, to ignore the open dialog when this file already open
	}
	catch(int nError)
	{
		return false;
	}
	return true;
}
bool XFWord::SaveDoc(LPCSTR lpcszFileName)
{
	bool bFileOpen=false;
	try
	{
		m_oActiveDoc.SaveAs(lpcszFileName);
	}
	catch(int nError)
	{
		 //bFileOpen=true;
		 string str;
		 str.Format("Please close the destination document: %s \nbefore creating it.", lpcszFileName);
		 MessageBox(GetWindow(), str, "Error!", MB_ICONHAND);
		 
		 m_oActiveDoc.Close(SaveChanges:=wdDoNotSaveChanges);
		 m_oActiveDoc=NULL;
		 return false;
	}
	/*
	if(bFileOpen)
	{
		Object oDocTemp;
		try
		{
			oDocTemp = m_oWord.Documents.Open(FileName:=lpcszFileName);
			oDocTemp.SaveAs(lpcszFileName);
		}
		catch(int nErr)
		{
			return false;
		}
	}
	*/
	return true;
}
bool XFWord::DeleteSection(LPCSTR lpcszBookMark)
{
	string str(lpcszBookMark);
	bool bRet=true;
	try
	{
		if(m_oActiveDoc.Bookmarks.Exists(str))
		{
			m_oWord.Selection.GoTo(What:= wdGoToBookmark, Name:=str);
			
			m_oWord.Selection.HomeKey(Unit:=wdLine);
			m_oWord.Selection.MoveDown(Unit:=wdLine, Count:=3, Extend:=wdExtend);
			m_oWord.Selection.Delete(Unit:=wdCharacter, Count:=1);
		}
		else
			bRet = false;
	}
	catch(int nErr)
	{
		return false;
	}
	return bRet;
}
//in template, table already exist, but for title, no table
bool XFWord::AddString(const string& str, LPCSTR lpcszTable, LPCSTR lpcszBookMark, LPCSTR lpcszStyle)
{
	Object oWordTable;
	if(NULL != lpcszTable)
	{
		if(!GetTable(lpcszBookMark, oWordTable))
			return false;
	}
	else
		AddBookMark(lpcszBookMark);
	
	return AddText(str);
}
///Joseph 11/30/06	SPLITE_TABLE_CELL_FOR_TREENODE_VARIABLE
//bool XFWord::AddRichText(const vector<char>& vcDoc, LPCSTR lpcszTable, LPCSTR lpcszBookMark, LPCSTR lpcszStyle) //=NULL, NULL
bool XFWord::AddRichText(const vector<char>& vcDoc, LPCSTR lpcszTable, LPCSTR lpcszBookMark, LPCSTR lpcszStyle, bool bIsTable) //=NULL, NULL
///End SPLITE_TABLE_CELL_FOR_TREENODE_VARIABLE
{
	Object oWordTable;
	if(bIsTable) ///Joseph 11/30/06	SPLITE_TABLE_CELL_FOR_TREENODE_VARIABLE
		GetTable(lpcszBookMark, oWordTable);
	///Joseph 11/30/06	SPLITE_TABLE_CELL_FOR_TREENODE_VARIABLE
	else
	{
		m_oWord.Selection.GoTo(What := wdGoToBookmark, Name:=lpcszBookMark);
		m_oWord.Selection.SelectCell();
	}
	///SPLITE_TABLE_CELL_FOR_TREENODE_VARIABLE
	bool bRet = doc2ActiveWord(vcDoc, lpcszStyle, bIsTable);
	putCursorToEnd();
	return bRet;
}

/// ----AW 11/03/05 ADD_HELP_SCREEN_SHOT
bool XFWord::AddImage(const vector<char>& vcDoc, LPCSTR lpcszTable, LPCSTR lpcszBookMark) //=NULL
{
	Object oWordTable;
	string strTableBookMark(lpcszBookMark);
	try
	{
		m_oWord.Selection.GoTo(What := wdGoToBookmark, Name:=strTableBookMark);
	}
	catch (int nerror)
	{
		error_report("Fail to Find ScreenShot bookMark");
		return false;
	}
	
	bool bRet = InsertImage(vcDoc);
	putCursorToEnd();
	return bRet;

}
/// ----END ADD_HELP_SCREEN_SHOT
bool XFWord::SplitTableCell(int nTableIndex, int nRow, int nCol, int nCols, LPCSTR lpcszTableBookMark, const vector<string>& vsVals, int nValCols, LPCSTR lpcszNewTableName, LPCSTR lpcszCellBookMark)
{
	string strBookMark(lpcszTableBookMark), strFillTemplate(STR_COMBOLIST_TEMPLATE_FILE), strTableName(lpcszNewTableName);
	string strCellBookMark(lpcszCellBookMark);
	try
	{
		///Joseph 11/30/06	SPLITE_TABLE_CELL_FOR_TREENODE_VARIABLE
		//split cell into 2 row
		//m_oWord.Selection.GoTo(What:= wdGoToBookmark, Name:=strBookMark);	//go to the bookmark first
		//m_oWord.Selection.Cells.Split(NumRows:=2, NumColumns:=1, MergeBeforeSplit:=false);
		//
		////enlarge the cell
		//m_oWord.Selection.Tables(1).Rows.SetHeight(RowHeight:=35, HeightRule:=wdRowHeightAtLeast);
		//
		////turn to the splitted cell
		//m_oWord.Selection.MoveDown(Unit:=wdLine, Count:=1);
		//m_oWord.Selection.MoveUp(Unit:=wdLine, Count:=1);
		//
		////book mark for cell, if keep if it is useful
		//strBookMark+="_list";//for the second splitted Cell
		//AddBookMark(strBookMark);
		//
		//m_oWord.Selection.TypeText(strTableName);
		SplitCellTwoRows(strBookMark, strTableName);
		strBookMark += "_list";
		m_oWord.Selection.GoTo(What:= wdGoToBookmark, Name:= strBookMark);
		m_oWord.Selection.TypeText(strTableName);
		///End SPLITE_TABLE_CELL_FOR_TREENODE_VARIABLE
		//if there is corrupted, change the template format, No table in template header!
		m_oWord.Selection.InsertFile(strFillTemplate);
		m_oWord.Selection.TypeBackspace();	//remove new junk line
		m_oWord.Selection.TypeBackspace();	//remove new junk line
		
		m_oWord.Selection.GoTo(What:= wdGoToBookmark, Name:=strBookMark);
		m_oWord.Selection.MoveDown(Unit:=wdLine, Count:=1);	//move inside edit table first cell
	}
	catch(int nErr)
	{
		printf("%s: %d\n%s\n", _L("Error on loading option list template, Please check"), nErr, strFillTemplate);
		return false;
	}
	return WordDocument::FillTable(vsVals, nValCols, nTableIndex, NULL, 0, strCellBookMark);
}
///Joseph 11/30/06	SPLITE_TABLE_CELL_FOR_TREENODE_VARIABLE
bool XFWord::SplitCellTwoRows(LPCSTR lpcszCellBookMark, LPCSTR lpcszNewCellName)
{
	string strBookMark(lpcszCellBookMark), strNewCellName(lpcszNewCellName);
	
	m_oWord.Selection.GoTo(What:= wdGoToBookmark, Name:=strBookMark);
	m_oWord.Selection.Cells.Split(NumRows:=2, NumColumns:=1, MergeBeforeSplit:=false);
	m_oWord.Selection.Tables(1).Rows.SetHeight(RowHeight:=35, HeightRule:=wdRowHeightAtLeast);
	
	//turn to the splitted cell
	m_oWord.Selection.MoveDown(Unit:=wdLine, Count:=1);
	m_oWord.Selection.MoveUp(Unit:=wdLine, Count:=1);
	
	strBookMark+="_list";//for the second splitted Cell
	AddBookMark(strBookMark);
	
	return true;
}
///End SPLITE_TABLE_CELL_FOR_TREENODE_VARIABLE
bool XFWord::GetString(LPCSTR lpcszBookMark, string& str, bool bTableString)
{
	if(!bTableString)
	{
		//still inside talbe, varialbe cell
		string strBookMark(lpcszBookMark);
		try
		{
			m_oWord.Selection.GoTo(What := wdGoToBookmark, Name:=strBookMark);
			m_oWord.Selection.SelectCell();
		
			str = m_oWord.Selection.Text;
		}
		catch(int nErr)
		{
			str.Empty();
			return false;
		}
		str = getDocString(str);
		return true;
	}
	
	return WordDocument::GetString(lpcszBookMark, str, bTableString);
}

/// Hong 09/25/07 v8.0708 XFDOC_REDUCE_SIZE_BY_REMOVE_NONGUI_HELP_INFO
bool clean_xf_doc(LPCSTR lpcszFileName);

bool clean_all_xf_docs(const string& strFolder);
/// end XFDOC_REDUCE_SIZE_BY_REMOVE_NONGUI_HELP_INFO

#endif //_XF_DOCUMENT_H